/*
 * Decompiled with CFR 0.152.
 */
package io.hubbox.propertieshelper;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PropertiesHelper {
    private static Properties p;
    private static String path;
    private static final Logger logger;

    private static PropertiesHelper getInstance() {
        return PropertiesHelperHolder.INSTANCE;
    }

    private PropertiesHelper() {
        try {
            File jarPath = new File(PropertiesHelper.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            path = jarPath.getParentFile().getAbsolutePath() + File.separator + "app.properties";
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(PropertiesHelper.class.getName()).log(Level.SEVERE, null, ex);
        }
        Path proppath = Paths.get(path, new String[0]);
        if (Files.exists(proppath, new LinkOption[0])) {
            PropertiesHelper.loadFromFile();
        } else {
            Properties properties;
            p = properties = new Properties();
            try {
                p.store(Files.newOutputStream(proppath, new OpenOption[0]), null);
            }
            catch (IOException ex) {
                Logger.getLogger(PropertiesHelper.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static Properties loadFromFile() {
        try {
            Path proppath = Paths.get(path, new String[0]);
            Properties properties = new Properties();
            properties.load(Files.newInputStream(proppath, new OpenOption[0]));
            p = properties;
        }
        catch (IOException ex) {
            Logger.getLogger(PropertiesHelper.class.getName()).log(Level.SEVERE, null, ex);
        }
        return PropertiesHelper.getProperties();
    }

    public static Properties getProperties() {
        PropertiesHelper.getInstance();
        return p;
    }

    public static boolean saveToFile(Properties properties) {
        PropertiesHelper.getInstance();
        Path proppath = Paths.get(path, new String[0]);
        try {
            properties.store(Files.newOutputStream(proppath, new OpenOption[0]), "Properties");
            return true;
        }
        catch (IOException e) {
            Logger.getLogger(PropertiesHelper.class.getName()).log(Level.SEVERE, null, e);
            return false;
        }
    }

    static {
        logger = Logger.getLogger(PropertiesHelper.class.getName());
    }

    private static class PropertiesHelperHolder {
        private static final PropertiesHelper INSTANCE = new PropertiesHelper();

        private PropertiesHelperHolder() {
        }
    }
}

