/*
 * Decompiled with CFR 0.152.
 */
package io.hubbox.rc2desktopclient;

import com.github.zafarkhaja.semver.Version;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.halimoglu.halimlogger.HalimAppender;
import com.halimoglu.halimlogger.HalimLogger;
import io.hubbox.propertieshelper.PropertiesHelper;
import io.hubbox.rc2desktopclient.Sr201Manager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.text.DefaultCaret;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.config.Configurator;

public class Rc2Frame
extends JFrame
implements HalimLogger {
    boolean isConnected1 = false;
    boolean isConnected2 = false;
    static final Color red = new Color(255, 51, 51);
    static final Color green = new Color(51, 204, 0);
    static final String s1 = "1";
    static final String s2 = "0";
    static final Version v = Version.valueOf("0.0.1");
    static final String title = "Rc2DesktopClient";
    static String update_link;
    static String latest_link;
    static String pth;
    int polling_interval = 300;
    String ip;
    int port1;
    int port2;
    private JDialog about_dialog;
    private JMenuItem appsettingsmenuitem;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JCheckBox cloud_enable_cb;
    private JTextField cloudpasstf;
    private JTextField cloudurltf;
    private JButton config_cancel_button;
    private JDialog config_dialog;
    private JButton config_save_button;
    private JButton connectbutton;
    private JMenuItem deviceconfmenuitem;
    private JTextField dnstf;
    private Box.Filler filler1;
    private Box.Filler filler2;
    private JTextField gatewaytf;
    private JLabel hwversionlabel;
    private JComboBox<String> ipcombobox;
    private JTextField iptf;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton22;
    private JButton jButton23;
    private JButton jButton3;
    private JComboBox<Level> jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel3;
    private JLabel jLabel35;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel50;
    private JLabel jLabel51;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextField jTextField24;
    private JTextArea log_area;
    private JDialog log_dialog;
    private JCheckBoxMenuItem logcheckbox;
    private JTextArea loglevels_area;
    private JTextField netmasktf;
    private JTextField portfield;
    private JTextField portfield2;
    private JRadioButton rememberrb;
    private JRadioButton resetrb;
    private JDialog settings_dialog;
    private JLabel swversionlabel;
    private JButton update_button;
    private JPanel updatepanel;

    public Rc2Frame() {
        try {
            pth = new File(Rc2Frame.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParentFile().getPath();
        }
        catch (URISyntaxException ex) {
            java.util.logging.Logger.getLogger(Rc2Frame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        this.setIconImage(new ImageIcon(this.getClass().getResource("/fav2.png")).getImage());
        this.initComponents();
        this.config_dialog.setIconImage(new ImageIcon(this.getClass().getResource("/fav2.png")).getImage());
        Image img = ((ImageIcon)this.jLabel2.getIcon()).getImage();
        Image img2 = img.getScaledInstance(this.jLabel2.getWidth(), this.jLabel2.getHeight(), 4);
        ImageIcon imageIcon = new ImageIcon(img2);
        this.jLabel2.setIcon(imageIcon);
        this.jMenuBar1.add(this.updatepanel);
        this.update_button.setVisible(false);
        Properties p = PropertiesHelper.getProperties();
        if (p.containsKey("ip_history")) {
            String history = p.getProperty("ip_history");
            String[] ips = history.split(",");
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.ipcombobox.getModel();
            model.removeAllElements();
            List<String> asList = Arrays.asList(ips);
            Iterator<String> iterator = asList.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                model.addElement(string);
            }
            this.ipcombobox.setModel(model);
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    if (Rc2Frame.this.ip == null) {
                        Rc2Frame.this.isConnected1 = false;
                        Rc2Frame.this.isConnected2 = false;
                    } else {
                        HashMap<String, Object> readGates = Sr201Manager.readGates(Rc2Frame.this.ip, Rc2Frame.this.port1);
                        Rc2Frame.this.isConnected1 = (Boolean)Sr201Manager.readGates(Rc2Frame.this.ip, Rc2Frame.this.port1).get("connected");
                    }
                    if (Rc2Frame.this.isConnected1) {
                        Rc2Frame.this.connectbutton.setText("Disconnect");
                        Rc2Frame.this.update_buttons(true, new JButton[]{Rc2Frame.this.jButton2, Rc2Frame.this.jButton3});
                        Rc2Frame.this.deviceconfmenuitem.setEnabled(true);
                    } else {
                        Rc2Frame.this.connectbutton.setText("Connect");
                        Rc2Frame.this.clearlabels();
                        Rc2Frame.this.update_buttons(false, new JButton[]{Rc2Frame.this.jButton2, Rc2Frame.this.jButton3});
                        Rc2Frame.this.deviceconfmenuitem.setEnabled(false);
                    }
                    if (Rc2Frame.this.isConnected1) {
                        HashMap<String, Object> gates = Sr201Manager.readGates(Rc2Frame.this.ip, Rc2Frame.this.port1);
                        boolean input = (Boolean)gates.get("input1");
                        boolean output = (Boolean)gates.get("output1");
                        Rc2Frame.this.updateInputLabel(1, input);
                        Rc2Frame.this.updateOutputLabel(1, output);
                    }
                    try {
                        Thread.sleep(Rc2Frame.this.polling_interval);
                        continue;
                    }
                    catch (InterruptedException ex) {
                        java.util.logging.Logger.getLogger(Rc2Frame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
                        continue;
                    }
                    break;
                }
            }
        }).start();
        this.updateCheckThread();
        Level[] levels = new Level[]{Level.OFF, Level.FATAL, Level.ERROR, Level.WARN, Level.INFO, Level.DEBUG, Level.TRACE, Level.ALL};
        this.jComboBox1.setModel(new DefaultComboBoxModel<Level>(levels));
        this.jComboBox1.setSelectedItem(((Logger)LogManager.getRootLogger()).getLevel());
        Logger log4j_logger = (Logger)LogManager.getRootLogger();
        HalimAppender ha = new HalimAppender(this);
        for (Appender a : log4j_logger.getAppenders().values()) {
            log4j_logger.removeAppender(a);
        }
        log4j_logger.addAppender(ha);
        DefaultCaret caret = (DefaultCaret)this.log_area.getCaret();
        caret.setUpdatePolicy(2);
    }

    private void clearlabels() {
        this.clear_button(this.jLabel20);
        this.clear_button(this.jLabel50);
    }

    private void clear_button(JLabel label) {
        label.setBackground(null);
        label.setText("");
    }

    private void update_buttons(boolean state, JButton ... jbs) {
        for (JButton jb : jbs) {
            jb.setEnabled(state);
        }
    }

    private void updateInputLabel(int i, boolean bit) {
        switch (i) {
            case 1: {
                this.jLabel20.setBackground(bit ? green : red);
                this.jLabel20.setText(bit ? s1 : s2);
            }
        }
    }

    private void updateOutputLabel(int i, boolean bit) {
        switch (i) {
            case 1: {
                this.jLabel50.setBackground(bit ? green : red);
                this.jLabel50.setText(bit ? s1 : s2);
            }
        }
    }

    private void initComponents() {
        this.config_dialog = new JDialog();
        this.jLabel4 = new JLabel();
        this.iptf = new JTextField();
        this.jLabel5 = new JLabel();
        this.netmasktf = new JTextField();
        this.jLabel8 = new JLabel();
        this.gatewaytf = new JTextField();
        this.jPanel3 = new JPanel();
        this.config_save_button = new JButton();
        this.filler1 = new Box.Filler(new Dimension(20, 0), new Dimension(20, 0), new Dimension(20, Short.MAX_VALUE));
        this.config_cancel_button = new JButton();
        this.jLabel11 = new JLabel();
        this.rememberrb = new JRadioButton();
        this.resetrb = new JRadioButton();
        this.jLabel21 = new JLabel();
        this.jLabel22 = new JLabel();
        this.hwversionlabel = new JLabel();
        this.swversionlabel = new JLabel();
        this.jLabel9 = new JLabel();
        this.dnstf = new JTextField();
        this.cloudurltf = new JTextField();
        this.jLabel10 = new JLabel();
        this.jLabel24 = new JLabel();
        this.cloud_enable_cb = new JCheckBox();
        this.cloudpasstf = new JTextField();
        this.jLabel25 = new JLabel();
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.updatepanel = new JPanel();
        this.update_button = new JButton();
        this.settings_dialog = new JDialog();
        this.jLabel13 = new JLabel();
        this.jTextField24 = new JTextField();
        this.jPanel7 = new JPanel();
        this.jButton22 = new JButton();
        this.filler2 = new Box.Filler(new Dimension(50, 0), new Dimension(50, 0), new Dimension(50, Short.MAX_VALUE));
        this.jButton23 = new JButton();
        this.jLabel14 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.loglevels_area = new JTextArea();
        this.jLabel23 = new JLabel();
        this.log_dialog = new JDialog();
        this.jButton1 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.log_area = new JTextArea();
        this.jLabel12 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.about_dialog = new JDialog();
        this.jPanel6 = new JPanel();
        this.jLabel15 = new JLabel();
        this.jLabel16 = new JLabel();
        this.jLabel17 = new JLabel();
        this.jLabel18 = new JLabel();
        this.jLabel19 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.connectbutton = new JButton();
        this.jLabel3 = new JLabel();
        this.portfield = new JTextField();
        this.ipcombobox = new JComboBox();
        this.portfield2 = new JTextField();
        this.jLabel2 = new JLabel();
        this.jPanel4 = new JPanel();
        this.jLabel20 = new JLabel();
        this.jLabel35 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jPanel5 = new JPanel();
        this.jLabel50 = new JLabel();
        this.jLabel51 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.deviceconfmenuitem = new JMenuItem();
        this.appsettingsmenuitem = new JMenuItem();
        this.logcheckbox = new JCheckBoxMenuItem();
        this.jMenuItem2 = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.jMenuItem3 = new JMenuItem();
        this.config_dialog.setTitle("Hubbox RC1 Settings");
        this.config_dialog.setModal(true);
        this.config_dialog.setResizable(false);
        this.config_dialog.setSize(new Dimension(410, 496));
        this.jLabel4.setFont(new Font("Segoe UI", 0, 18));
        this.jLabel4.setText("IP");
        this.iptf.setFont(new Font("Tahoma", 0, 20));
        this.jLabel5.setFont(new Font("Segoe UI", 0, 18));
        this.jLabel5.setText("Netmask");
        this.netmasktf.setFont(new Font("Tahoma", 0, 20));
        this.netmasktf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Rc2Frame.this.netmasktfActionPerformed(evt);
            }
        });
        this.jLabel8.setFont(new Font("Segoe UI", 0, 18));
        this.jLabel8.setText("Gateway");
        this.gatewaytf.setFont(new Font("Tahoma", 0, 20));
        this.config_save_button.setFont(new Font("Segoe UI Semibold", 0, 14));
        this.config_save_button.setText("SAVE");
        this.config_save_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Rc2Frame.this.config_save_buttonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.config_save_button);
        this.jPanel3.add(this.filler1);
        this.config_cancel_button.setFont(new Font("Segoe UI Semibold", 0, 14));
        this.config_cancel_button.setText("CANCEL");
        this.config_cancel_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Rc2Frame.this.config_cancel_buttonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.config_cancel_button);
        this.jLabel11.setFont(new Font("Segoe UI", 0, 18));
        this.jLabel11.setText("Output Mode");
        this.buttonGroup2.add(this.rememberrb);
        this.rememberrb.setFont(new Font("Segoe UI", 0, 14));
        this.rememberrb.setText("remember last state");
        this.buttonGroup2.add(this.resetrb);
        this.resetrb.setFont(new Font("Segoe UI", 0, 14));
        this.resetrb.setText("reset");
        this.jLabel21.setFont(new Font("Segoe UI", 0, 18));
        this.jLabel21.setText("HW serial");
        this.jLabel22.setFont(new Font("Segoe UI", 0, 18));
        this.jLabel22.setText("SW version");
        this.hwversionlabel.setFont(new Font("Tahoma", 0, 18));
        this.swversionlabel.setFont(new Font("Tahoma", 0, 18));
        this.jLabel9.setFont(new Font("Segoe UI", 0, 18));
        this.jLabel9.setText("DNS");
        this.dnstf.setFont(new Font("Tahoma", 0, 20));
        this.cloudurltf.setFont(new Font("Tahoma", 0, 20));
        this.jLabel10.setFont(new Font("Segoe UI", 0, 18));
        this.jLabel10.setText("Cloud url");
        this.jLabel24.setFont(new Font("Segoe UI", 0, 18));
        this.jLabel24.setText("Cloud enabled");
        this.cloud_enable_cb.setFont(new Font("Segoe UI", 0, 24));
        this.cloudpasstf.setFont(new Font("Tahoma", 0, 20));
        this.jLabel25.setFont(new Font("Segoe UI", 0, 18));
        this.jLabel25.setText("Cloud pass");
        GroupLayout config_dialogLayout = new GroupLayout(this.config_dialog.getContentPane());
        this.config_dialog.getContentPane().setLayout(config_dialogLayout);
        config_dialogLayout.setHorizontalGroup(config_dialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(config_dialogLayout.createSequentialGroup().addContainerGap().addGroup(config_dialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(config_dialogLayout.createSequentialGroup().addGroup(config_dialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel9).addComponent(this.jLabel10).addComponent(this.jLabel25)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(config_dialogLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.cloudurltf, GroupLayout.Alignment.LEADING, -1, 283, Short.MAX_VALUE).addComponent(this.dnstf).addComponent(this.cloudpasstf))).addGroup(config_dialogLayout.createSequentialGroup().addGroup(config_dialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel11).addComponent(this.jLabel21).addComponent(this.jLabel22)).addGap(18, 18, 18).addGroup(config_dialogLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.hwversionlabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, config_dialogLayout.createSequentialGroup().addComponent(this.rememberrb).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.resetrb)).addComponent(this.swversionlabel, -1, -1, Short.MAX_VALUE))).addGroup(config_dialogLayout.createSequentialGroup().addComponent(this.jLabel24).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cloud_enable_cb)).addGroup(config_dialogLayout.createSequentialGroup().addGroup(config_dialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel5).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(config_dialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.netmasktf, -1, 295, Short.MAX_VALUE).addComponent(this.iptf).addComponent(this.gatewaytf))).addComponent(this.jPanel3, -1, 377, Short.MAX_VALUE)).addContainerGap(18, Short.MAX_VALUE)));
        config_dialogLayout.setVerticalGroup(config_dialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(config_dialogLayout.createSequentialGroup().addContainerGap().addGroup(config_dialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.iptf, -2, -1, -2).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(config_dialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.netmasktf, -2, -1, -2).addComponent(this.jLabel5, -2, 35, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(config_dialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.gatewaytf, -2, -1, -2).addComponent(this.jLabel8, -2, 35, -2)).addGap(18, 18, 18).addGroup(config_dialogLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11, -2, 35, -2).addComponent(this.rememberrb).addComponent(this.resetrb)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(config_dialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel21, -1, -1, Short.MAX_VALUE).addComponent(this.hwversionlabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(config_dialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel22, -1, -1, Short.MAX_VALUE).addComponent(this.swversionlabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(config_dialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.dnstf, -2, -1, -2).addComponent(this.jLabel9, -2, 35, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(config_dialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.cloudurltf, -2, -1, -2).addComponent(this.jLabel10, -2, 35, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(config_dialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.cloudpasstf, -2, -1, -2).addComponent(this.jLabel25, -2, 35, -2)).addGap(12, 12, 12).addGroup(config_dialogLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel24, -2, 35, -2).addComponent(this.cloud_enable_cb, -2, 35, -2)).addGap(6, 6, 6).addComponent(this.jPanel3, -2, -1, -2).addGap(20, 20, 20)));
        this.updatepanel.setBackground(new Color(255, 255, 255));
        this.updatepanel.setLayout(new BorderLayout());
        this.update_button.setText("update");
        this.update_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Rc2Frame.this.update_buttonActionPerformed(evt);
            }
        });
        this.updatepanel.add((Component)this.update_button, "East");
        this.settings_dialog.setTitle("RC1 Manager Configuration");
        this.jLabel13.setFont(new Font("Tahoma", 0, 18));
        this.jLabel13.setText("Polling Interval (ms)");
        this.jTextField24.setFont(new Font("Tahoma", 0, 24));
        this.jButton22.setFont(new Font("Tahoma", 0, 14));
        this.jButton22.setText("SAVE");
        this.jButton22.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Rc2Frame.this.jButton22ActionPerformed(evt);
            }
        });
        this.jPanel7.add(this.jButton22);
        this.jPanel7.add(this.filler2);
        this.jButton23.setFont(new Font("Tahoma", 0, 14));
        this.jButton23.setText("CANCEL");
        this.jButton23.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Rc2Frame.this.jButton23ActionPerformed(evt);
            }
        });
        this.jPanel7.add(this.jButton23);
        this.jLabel14.setFont(new Font("Tahoma", 0, 18));
        this.jLabel14.setText("Log Levels");
        this.loglevels_area.setColumns(20);
        this.loglevels_area.setRows(5);
        this.jScrollPane2.setViewportView(this.loglevels_area);
        this.jLabel23.setFont(new Font("Tahoma", 0, 12));
        this.jLabel23.setText("<html>OFF<br/>FATAL<br/>ERROR<br/>WARN<br/>INFO<br/>DEBUG<br/>TRACE<br/>ALL</html>");
        GroupLayout settings_dialogLayout = new GroupLayout(this.settings_dialog.getContentPane());
        this.settings_dialog.getContentPane().setLayout(settings_dialogLayout);
        settings_dialogLayout.setHorizontalGroup(settings_dialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(settings_dialogLayout.createSequentialGroup().addContainerGap().addGroup(settings_dialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(settings_dialogLayout.createSequentialGroup().addComponent(this.jLabel13).addGap(20, 20, 20).addComponent(this.jTextField24)).addComponent(this.jPanel7, GroupLayout.Alignment.TRAILING, -1, 537, Short.MAX_VALUE).addGroup(settings_dialogLayout.createSequentialGroup().addGroup(settings_dialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel14, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel23)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane2))).addContainerGap()));
        settings_dialogLayout.setVerticalGroup(settings_dialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(settings_dialogLayout.createSequentialGroup().addContainerGap().addGroup(settings_dialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel13, -1, -1, Short.MAX_VALUE).addComponent(this.jTextField24)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(settings_dialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(settings_dialogLayout.createSequentialGroup().addComponent(this.jLabel14).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel23, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jScrollPane2)).addGap(6, 6, 6).addComponent(this.jPanel7, -2, -1, -2).addGap(6, 6, 6)));
        this.log_dialog.setTitle("Log");
        this.log_dialog.setSize(new Dimension(400, 300));
        this.log_dialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent evt) {
                Rc2Frame.this.log_dialogComponentHidden(evt);
            }
        });
        this.log_dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                Rc2Frame.this.log_dialogWindowClosed(evt);
            }
        });
        this.jButton1.setText("clear");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Rc2Frame.this.jButton1ActionPerformed(evt);
            }
        });
        this.log_area.setColumns(20);
        this.log_area.setRows(5);
        this.jScrollPane1.setViewportView(this.log_area);
        this.jLabel12.setText("global logger level");
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Rc2Frame.this.jComboBox1ActionPerformed(evt);
            }
        });
        GroupLayout log_dialogLayout = new GroupLayout(this.log_dialog.getContentPane());
        this.log_dialog.getContentPane().setLayout(log_dialogLayout);
        log_dialogLayout.setHorizontalGroup(log_dialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(log_dialogLayout.createSequentialGroup().addGap(6, 6, 6).addGroup(log_dialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(log_dialogLayout.createSequentialGroup().addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 213, Short.MAX_VALUE).addComponent(this.jLabel12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox1, -2, -1, -2)).addComponent(this.jScrollPane1)).addGap(6, 6, 6)));
        log_dialogLayout.setVerticalGroup(log_dialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, log_dialogLayout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jScrollPane1, -1, 258, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(log_dialogLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jLabel12).addComponent(this.jComboBox1, -2, -1, -2)).addGap(6, 6, 6)));
        this.about_dialog.setBackground(new Color(255, 255, 255));
        this.about_dialog.setModal(true);
        this.about_dialog.setResizable(false);
        this.about_dialog.setSize(new Dimension(460, 370));
        this.about_dialog.setType(Window.Type.POPUP);
        this.jPanel6.setBackground(new Color(255, 255, 255));
        this.jLabel15.setIcon(new ImageIcon(this.getClass().getResource("/logo_transparent.png")));
        this.jLabel15.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Rc2Frame.this.jLabel15MouseClicked(evt);
            }
        });
        this.jLabel16.setFont(new Font("Tahoma", 0, 18));
        this.jLabel16.setForeground(new Color(51, 153, 0));
        this.jLabel16.setText("http://hubbox.io");
        this.jLabel16.setOpaque(true);
        this.jLabel16.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Rc2Frame.this.jLabel16MouseClicked(evt);
            }
        });
        this.jLabel17.setFont(new Font("Tahoma", 0, 18));
        this.jLabel17.setForeground(new Color(51, 153, 0));
        this.jLabel17.setText("http://twitter.com/hubboxio");
        this.jLabel17.setOpaque(true);
        this.jLabel17.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Rc2Frame.this.jLabel17MouseClicked(evt);
            }
        });
        this.jLabel18.setFont(new Font("Tahoma", 0, 18));
        this.jLabel18.setForeground(new Color(51, 153, 0));
        this.jLabel18.setText("http://youtube.com/hubboxiot");
        this.jLabel18.setOpaque(true);
        this.jLabel18.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Rc2Frame.this.jLabel18MouseClicked(evt);
            }
        });
        this.jLabel19.setFont(new Font("Tahoma", 0, 18));
        this.jLabel19.setForeground(new Color(51, 153, 0));
        this.jLabel19.setText("http://instagram.com/hubbox.io");
        this.jLabel19.setOpaque(true);
        this.jLabel19.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Rc2Frame.this.jLabel19MouseClicked(evt);
            }
        });
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel15, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel16, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel17, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel19, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel18, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jLabel15, -2, 130, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel16, -2, 37, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel17, -2, 37, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel19, -2, 37, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel18, -2, 37, -2).addGap(0, 0, Short.MAX_VALUE)));
        GroupLayout about_dialogLayout = new GroupLayout(this.about_dialog.getContentPane());
        this.about_dialog.getContentPane().setLayout(about_dialogLayout);
        about_dialogLayout.setHorizontalGroup(about_dialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel6, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        about_dialogLayout.setVerticalGroup(about_dialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel6, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        this.setDefaultCloseOperation(3);
        this.setTitle("Hubbox RC2 Manager v" + v.getNormalVersion());
        this.setResizable(false);
        this.jPanel2.setBackground(new Color(255, 255, 255));
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jLabel1.setFont(new Font("Tahoma", 0, 14));
        this.jLabel1.setText("IP");
        this.connectbutton.setFont(new Font("Segoe UI", 0, 14));
        this.connectbutton.setText("connect");
        this.connectbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Rc2Frame.this.connectbuttonActionPerformed(evt);
            }
        });
        this.jLabel3.setFont(new Font("Tahoma", 0, 14));
        this.jLabel3.setText("PORT");
        this.portfield.setFont(new Font("Segoe UI", 0, 14));
        this.portfield.setText("6722");
        this.ipcombobox.setEditable(true);
        this.ipcombobox.setFont(new Font("Segoe UI", 0, 14));
        this.ipcombobox.setModel(new DefaultComboBoxModel<String>(new String[]{"192.168.24.251"}));
        this.ipcombobox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Rc2Frame.this.ipcomboboxActionPerformed(evt);
            }
        });
        this.portfield2.setFont(new Font("Segoe UI", 0, 14));
        this.portfield2.setText("5111");
        this.portfield2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Rc2Frame.this.portfield2ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(17, Short.MAX_VALUE).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ipcombobox, -2, 145, -2).addGap(18, 18, 18).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.portfield, -2, 64, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.portfield2, -2, 64, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.connectbutton).addGap(12, 12, 12)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.connectbutton).addComponent(this.jLabel3).addComponent(this.portfield, -2, -1, -2).addComponent(this.ipcombobox, -2, -1, -2).addComponent(this.portfield2, -2, -1, -2)).addGap(40, 40, 40)));
        this.jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/logo_transparent.png")));
        this.jLabel2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Rc2Frame.this.jLabel2MouseClicked(evt);
            }
        });
        this.jPanel4.setBackground(new Color(255, 255, 255));
        this.jLabel20.setFont(new Font("Tahoma", 0, 14));
        this.jLabel20.setHorizontalAlignment(0);
        this.jLabel20.setOpaque(true);
        this.jLabel35.setFont(new Font("Segoe UI", 0, 14));
        this.jLabel35.setHorizontalAlignment(0);
        this.jLabel35.setText("#1");
        this.jLabel6.setFont(new Font("Segoe UI", 0, 14));
        this.jLabel6.setText("INPUT");
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel6).addGap(25, 25, 25).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel20, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel35, -2, 29, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGap(6, 6, 6).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel6, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel20, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel35, -2, 29, -2).addGap(6, 6, 6)))));
        this.jPanel5.setBackground(new Color(255, 255, 255));
        this.jLabel50.setFont(new Font("Tahoma", 0, 14));
        this.jLabel50.setHorizontalAlignment(0);
        this.jLabel50.setOpaque(true);
        this.jLabel51.setFont(new Font("Segoe UI", 0, 14));
        this.jLabel51.setHorizontalAlignment(0);
        this.jLabel51.setText("#1");
        this.jLabel7.setFont(new Font("Segoe UI", 0, 14));
        this.jLabel7.setText("OUTPUT");
        this.jButton2.setText("on");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Rc2Frame.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButton3.setText("off");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Rc2Frame.this.jButton3ActionPerformed(evt);
            }
        });
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel7).addGap(25, 25, 25).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButton2, GroupLayout.Alignment.LEADING, -2, 0, Short.MAX_VALUE).addComponent(this.jLabel51, GroupLayout.Alignment.LEADING, -1, 47, Short.MAX_VALUE).addComponent(this.jLabel50, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jButton3, -2, 0, Short.MAX_VALUE)).addContainerGap(35, Short.MAX_VALUE)));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.jLabel50, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel51, -2, 29, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3).addGap(6, 11, Short.MAX_VALUE)).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.jLabel7, -1, -1, Short.MAX_VALUE).addContainerGap()))));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jPanel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jPanel5, -2, -1, -2)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel2, -2, 107, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE))).addGap(10, 10, 10)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel2, -2, 40, -2).addComponent(this.jPanel1, -1, 0, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel5, -2, -1, -2).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jMenu1.setText("File");
        this.deviceconfmenuitem.setText("Device Configuration");
        this.deviceconfmenuitem.setEnabled(false);
        this.deviceconfmenuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Rc2Frame.this.deviceconfmenuitemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.deviceconfmenuitem);
        this.appsettingsmenuitem.setText("App Settings");
        this.appsettingsmenuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Rc2Frame.this.appsettingsmenuitemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.appsettingsmenuitem);
        this.logcheckbox.setText("Log");
        this.logcheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Rc2Frame.this.logcheckboxActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.logcheckbox);
        this.jMenuItem2.setText("Exit");
        this.jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Rc2Frame.this.jMenuItem2ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem2);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setText("Help");
        this.jMenuItem3.setText("About RC2 Desktop Client");
        this.jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Rc2Frame.this.jMenuItem3ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem3);
        this.jMenuBar1.add(this.jMenu2);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jMenuItem2ActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void deviceconfmenuitemActionPerformed(ActionEvent evt) {
        HashMap<String, Object> conf = Sr201Manager.readConf(this.ip, this.port2);
        this.isConnected2 = (Boolean)conf.get("connected");
        if (this.isConnected2) {
            String cloudurl;
            this.iptf.setText((String)conf.get("ip"));
            this.netmasktf.setText((String)conf.get("netmask"));
            this.gatewaytf.setText((String)conf.get("gateway"));
            boolean remember = (Boolean)conf.get("remember_last_state");
            if (remember) {
                this.rememberrb.setSelected(true);
            } else {
                this.resetrb.setSelected(true);
            }
            this.hwversionlabel.setText((String)conf.get("device_serial"));
            this.swversionlabel.setText((String)conf.get("firmware_version"));
            this.dnstf.setText((String)conf.get("dns"));
            Object curl = conf.get("cloud_url");
            if (curl != null && (cloudurl = (String)curl).contains("box")) {
                this.cloudurltf.setText(cloudurl);
            }
            boolean clound_enabled = (Boolean)conf.get("cloud_enabled");
            this.cloud_enable_cb.setSelected(clound_enabled);
            this.cloudpasstf.setText((String)conf.get("cloud_pass"));
        }
        this.config_dialog.setVisible(true);
    }

    private void connectbuttonActionPerformed(ActionEvent evt) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (Rc2Frame.this.isConnected1) {
                    Sr201Manager.disconnectDevice(Rc2Frame.this.ip, Rc2Frame.this.port1);
                    Sr201Manager.disconnectDevice(Rc2Frame.this.ip, Rc2Frame.this.port2);
                    Rc2Frame.this.ip = null;
                } else {
                    String ip = (String)Rc2Frame.this.ipcombobox.getSelectedItem();
                    InetAddressValidator inetValidator = InetAddressValidator.getInstance();
                    boolean b = inetValidator.isValidInet4Address(ip);
                    if (!b) {
                        JOptionPane.showMessageDialog(Rc2Frame.this, "IP Address is invalid", "INVALID PARAMETER", 0);
                        return;
                    }
                    Rc2Frame.this.ip = ip;
                    String port1 = Rc2Frame.this.portfield.getText();
                    String port2 = Rc2Frame.this.portfield2.getText();
                    boolean porthata = false;
                    int portint1 = -1;
                    int portint2 = -1;
                    try {
                        portint1 = Integer.parseInt(port1);
                        portint2 = Integer.parseInt(port2);
                        if (portint1 < 0 || portint1 > 65535 || portint2 < 0 || portint2 > 65535) {
                            porthata = true;
                        }
                    }
                    catch (Exception e) {
                        porthata = true;
                    }
                    if (porthata) {
                        JOptionPane.showMessageDialog(Rc2Frame.this, "Port number is invalid", "INVALID PARAMETER", 0);
                        return;
                    }
                    Rc2Frame.this.port1 = portint1;
                    Rc2Frame.this.port2 = portint2;
                    Sr201Manager.closeAll();
                    HashMap<String, Object> readGates = Sr201Manager.readGates(ip, portint1);
                    Rc2Frame.this.update_ip_history();
                }
            }
        }).start();
    }

    private void update_ip_history() {
        Properties p = PropertiesHelper.getProperties();
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.ipcombobox.getModel();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < model.getSize(); ++i) {
            sb.append((String)model.getElementAt(i) + ",");
            if (i > 10) break;
        }
        sb.deleteCharAt(sb.length() - 1);
        p.setProperty("ip_history", sb.toString());
        PropertiesHelper.saveToFile(p);
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.setoutput(1, true);
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.setoutput(1, false);
    }

    private void jLabel2MouseClicked(MouseEvent evt) {
        this.browse("https://hubbox.io");
    }

    private void browse(String url) {
        Desktop desktop;
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(URI.create(url));
            }
            catch (IOException ex) {
                java.util.logging.Logger.getLogger(Rc2Frame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
            }
        }
    }

    private void update_buttonActionPerformed(ActionEvent evt) {
        Object fileOutputStream;
        try {
            ReadableByteChannel readableByteChannel = Channels.newChannel(new URL(update_link).openStream());
            fileOutputStream = new FileOutputStream(new File(pth, "Rc2DesktopClient_updater.jar"));
            ((FileOutputStream)fileOutputStream).getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
        }
        catch (MalformedURLException ex) {
            java.util.logging.Logger.getLogger(Rc2Frame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            java.util.logging.Logger.getLogger(Rc2Frame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        ProcessBuilder pb = new ProcessBuilder("java", "-jar", "Rc2DesktopClient_updater.jar", title, latest_link);
        pb.directory(new File(pth));
        try {
            fileOutputStream = pb.start();
        }
        catch (IOException ex) {
            java.util.logging.Logger.getLogger(Rc2Frame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        try {
            this.setVisible(false);
            this.dispose();
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            java.util.logging.Logger.getLogger(Rc2Frame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        System.exit(0);
    }

    private void jMenuItem3ActionPerformed(ActionEvent evt) {
        this.about_dialog.setVisible(true);
    }

    private void appsettingsmenuitemActionPerformed(ActionEvent evt) {
        Dimension d = this.settings_dialog.getPreferredSize();
        this.settings_dialog.setSize(new Dimension(d.width + 50, d.height + 50));
        Properties p = PropertiesHelper.getProperties();
        if (p.containsKey("polling_interval")) {
            this.polling_interval = Integer.parseInt(p.getProperty("polling_interval"));
        } else {
            p.setProperty("polling_interval", "300");
            PropertiesHelper.saveToFile(p);
        }
        this.jTextField24.setText(this.polling_interval + "");
        if (!p.containsKey("loggers")) {
            p.setProperty("loggers", "com.ghgande.j2mod.modbus.io.ModbusTCPTransport,com.ghgande.j2mod.modbus.io.FastByteArrayInputStream,com.ghgande.j2mod.modbus.io.ModbusTCPTransaction,com.ghgande.j2mod.modbus.util.BitVector,com.ghgande.j2mod.modbus.net.TCPMasterConnection");
            p.setProperty("com.ghgande.j2mod.modbus.io.ModbusTCPTransport", Level.INFO.name());
            p.setProperty("com.ghgande.j2mod.modbus.io.FastByteArrayInputStream", Level.INFO.name());
            p.setProperty("com.ghgande.j2mod.modbus.io.ModbusTCPTransaction", Level.INFO.name());
            p.setProperty("com.ghgande.j2mod.modbus.util.BitVector", Level.INFO.name());
            p.setProperty("com.ghgande.j2mod.modbus.net.TCPMasterConnection", Level.INFO.name());
            StringBuilder sb = new StringBuilder();
            sb.append("com.ghgande.j2mod.modbus.io.ModbusTCPTransport:" + Level.INFO.name() + System.lineSeparator());
            sb.append("com.ghgande.j2mod.modbus.io.FastByteArrayInputStream:" + Level.INFO.name() + System.lineSeparator());
            sb.append("com.ghgande.j2mod.modbus.io.ModbusTCPTransaction:" + Level.INFO.name() + System.lineSeparator());
            sb.append("ccom.ghgande.j2mod.modbus.util.BitVector:" + Level.INFO.name() + System.lineSeparator());
            sb.append("com.ghgande.j2mod.modbus.net.TCPMasterConnection:" + Level.INFO.name() + System.lineSeparator());
            this.loglevels_area.setText(sb.toString());
            PropertiesHelper.saveToFile(p);
        } else {
            String[] loggers = p.getProperty("loggers").split(",");
            StringBuilder sb = new StringBuilder();
            for (String logger : loggers) {
                sb.append(logger + ":" + p.getProperty(logger) + System.lineSeparator());
            }
            this.loglevels_area.setText(sb.toString());
        }
        this.settings_dialog.setVisible(true);
    }

    private void jButton23ActionPerformed(ActionEvent evt) {
        this.settings_dialog.setVisible(false);
    }

    private void jButton22ActionPerformed(ActionEvent evt) {
        String[] lines;
        this.polling_interval = Integer.parseInt(this.jTextField24.getText());
        Properties p = PropertiesHelper.getProperties();
        p.setProperty("polling_interval", this.polling_interval + "");
        String loggers = this.loglevels_area.getText();
        for (String line : lines = loggers.split(System.lineSeparator())) {
            String[] split = line.split(":");
            String klas = split[0];
            String level = split[1];
            Configurator.setLevel(klas, Level.valueOf(level));
            p.setProperty(klas, level);
        }
        PropertiesHelper.saveToFile(p);
        this.settings_dialog.setVisible(false);
    }

    private void logcheckboxActionPerformed(ActionEvent evt) {
        AbstractButton aButton = (AbstractButton)evt.getSource();
        boolean selected = aButton.getModel().isSelected();
        this.log_dialog.setVisible(selected);
    }

    private void log_dialogWindowClosed(WindowEvent evt) {
    }

    private void log_dialogComponentHidden(ComponentEvent evt) {
        this.logcheckbox.setState(false);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.log_area.setText("");
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        Level level = this.jComboBox1.getItemAt(this.jComboBox1.getSelectedIndex());
        Configurator.setRootLevel(level);
    }

    private void ipcomboboxActionPerformed(ActionEvent evt) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.ipcombobox.getModel();
        int index = this.ipcombobox.getSelectedIndex();
        if (index == -1) {
            String ip = (String)this.ipcombobox.getEditor().getItem();
            InetAddressValidator inetValidator = InetAddressValidator.getInstance();
            boolean b = inetValidator.isValidInet4Address(ip);
            if (b) {
                model.insertElementAt(ip, 0);
            }
        } else {
            String s = (String)model.getElementAt(index);
            model.removeElement(s);
            model.insertElementAt(s, 0);
            this.ipcombobox.setSelectedIndex(0);
        }
    }

    private void jLabel15MouseClicked(MouseEvent evt) {
    }

    private void jLabel16MouseClicked(MouseEvent evt) {
        this.browse("https://hubbox.io");
    }

    private void jLabel17MouseClicked(MouseEvent evt) {
        this.browse("https://twitter.com/hubboxio");
    }

    private void jLabel19MouseClicked(MouseEvent evt) {
        this.browse("https://instagram.com/hubbox.io");
    }

    private void jLabel18MouseClicked(MouseEvent evt) {
        this.browse("https://youtube.com/hubboxiot");
    }

    private void portfield2ActionPerformed(ActionEvent evt) {
    }

    private void config_cancel_buttonActionPerformed(ActionEvent evt) {
        this.iptf.setText("");
        this.netmasktf.setText("");
        this.gatewaytf.setText("");
        this.dnstf.setText("");
        this.cloudurltf.setText("");
        this.cloudpasstf.setText("");
        this.config_dialog.setVisible(false);
    }

    private void config_save_buttonActionPerformed(ActionEvent evt) {
        String ip1 = this.iptf.getText();
        String netmask1 = this.netmasktf.getText();
        String gateway1 = this.gatewaytf.getText();
        String hw_serial = this.hwversionlabel.getText();
        String firmware_version = this.swversionlabel.getText();
        String dns = this.dnstf.getText();
        String cloud_url = this.cloudurltf.getText();
        boolean cloud_enabled = this.cloud_enable_cb.isSelected();
        String cloud_pass = this.cloudpasstf.getText();
        boolean outputmode = this.rememberrb.isSelected();
        if (this.isConnected2) {
            Object sonuc = Sr201Manager.setConf(this.ip, this.port2, ip1, netmask1, gateway1, outputmode, dns, cloud_url, cloud_enabled, cloud_pass);
            Sr201Manager.closeAll();
            this.config_dialog.setVisible(false);
        }
    }

    private void netmasktfActionPerformed(ActionEvent evt) {
    }

    private void setoutput(int i, boolean b) {
        if (this.isConnected1) {
            Sr201Manager.setSingleOutput(this.ip, this.port1, i, b);
        }
    }

    public static void main(String[] args) {
        System.setProperty("java.util.logging.manager", "org.apache.logging.log4j.jul.LogManager");
        Configurator.setRootLevel(Level.INFO);
        Logger log4j_logger = (Logger)LogManager.getRootLogger();
        java.util.logging.Logger jul_logger = java.util.logging.Logger.getLogger(Rc2Frame.class.getName());
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Windows".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(Rc2Frame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(Rc2Frame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(Rc2Frame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(Rc2Frame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Rc2Frame().setVisible(true);
            }
        });
    }

    @Override
    public void append(String log) {
        if (this.log_dialog.isVisible()) {
            this.log_area.append(log + System.lineSeparator());
        }
    }

    private void updateCheckThread() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                this.needUpdate();
            }

            public boolean needUpdate() {
                JsonObject istek = new JsonObject();
                istek.addProperty("name", Rc2Frame.title);
                try {
                    HttpRequest request = HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofString(istek.toString(), StandardCharsets.UTF_8)).header("Content-Type", "application/json").uri(URI.create("https://manager.hubbox.io/api/findsoftware")).build();
                    HttpResponse<String> response = HttpClient.newBuilder().build().send(request, HttpResponse.BodyHandlers.ofString());
                    String body = response.body();
                    JsonObject jo = JsonParser.parseString(body).getAsJsonObject();
                    System.out.println(jo.toString());
                    Version latest = Version.valueOf(jo.get("data").getAsJsonObject().get("latest_version").getAsString());
                    if (latest.greaterThan(v)) {
                        update_link = jo.get("data").getAsJsonObject().get("update_link").getAsString();
                        latest_link = jo.get("data").getAsJsonObject().get("link").getAsString();
                        Rc2Frame.this.update_button.setVisible(true);
                    }
                }
                catch (IOException ex) {
                    java.util.logging.Logger.getLogger(Rc2Frame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
                }
                catch (InterruptedException ex) {
                    java.util.logging.Logger.getLogger(Rc2Frame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
                }
                return false;
            }
        }).start();
    }
}

