/*
 * Decompiled with CFR 0.152.
 */
package com.halimoglu.halimlogger;

import com.halimoglu.halimlogger.HalimLogger;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;

public class HalimAppender
extends AbstractAppender {
    HalimLogger hl;
    static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public HalimAppender(HalimLogger hl) {
        super("halimlogger", null, null, true, null);
        this.hl = hl;
    }

    @Override
    public void append(LogEvent event) {
        StringBuilder sb = new StringBuilder();
        sb.append(sdf.format(new Date()) + " ");
        sb.append(event.getLevel() + " ");
        sb.append(event.getSource().getClassName() + " [");
        sb.append(event.getSource().getMethodName() + ":");
        sb.append(event.getSource().getLineNumber() + "] ");
        if (event.getThrown() != null) {
            sb.append(event.getThrown().toString());
        }
        if (!event.getMessage().getFormattedMessage().equals("null")) {
            sb.append(event.getMessage().getFormattedMessage() + " ");
        }
        this.hl.append(sb.toString());
        if (event.getThrown() != null) {
            event.getThrown().printStackTrace();
        }
    }
}

