/*
 * Decompiled with CFR 0.152.
 */
package io.hubbox.rc2desktopclient;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.CharsetUtil;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NettyClient {
    static final byte off = 48;
    static final byte on = 49;
    private String serverHost;
    private int serverPort;
    private Bootstrap bootstrap;
    private EventLoopGroup workerGroup;
    private ChannelFuture future;
    private Channel clientChannel;
    private int globalRetryCount = Integer.MAX_VALUE;
    long last_update1 = -1L;
    long last_update2 = -1L;
    boolean output;
    boolean input;
    Thread extra_t;
    int type;
    String ip;
    String netmask;
    String gateway;
    String firmware_version;
    String device_serial;
    String dns;
    String cloud_url;
    String cloud_pass;
    boolean remember_last_state;
    boolean cloud_enabled;
    SynchronousQueue<Object> sync_result = new SynchronousQueue();
    private static final Logger logger = Logger.getLogger(NettyClient.class.getName());

    public NettyClient(String serverHost, int serverPort, int type) {
        this.serverHost = serverHost;
        this.serverPort = serverPort;
        this.bootstrap = new Bootstrap();
        this.workerGroup = new NioEventLoopGroup();
        this.type = type;
        if (type == 2) {
            this.globalRetryCount = -1;
        }
    }

    public String getServerHost() {
        return this.serverHost;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void connect() {
        this.bootstrap.group(this.workerGroup);
        this.bootstrap.channel(NioSocketChannel.class);
        this.bootstrap.option(ChannelOption.TCP_NODELAY, true);
        this.bootstrap.option(ChannelOption.SO_KEEPALIVE, true);
        this.bootstrap.handler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel socketChannel) throws Exception {
                ChannelPipeline pipeline = socketChannel.pipeline();
                pipeline.addLast("readTimeoutHandler", (ChannelHandler)new ReadTimeoutHandler(5));
                pipeline.addLast(new SimpleChannelInboundHandler(){

                    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
                        ByteBuf in = (ByteBuf)msg;
                        if (NettyClient.this.type == 1) {
                            NettyClient.this.output = in.getByte(0) == 49;
                            NettyClient.this.input = in.getByte(1) == 49;
                            NettyClient.this.last_update1 = System.currentTimeMillis();
                        } else if (NettyClient.this.type == 2) {
                            String data = in.toString(CharsetUtil.UTF_8);
                            if (data.startsWith(">")) {
                                if ((data = data.substring(1, data.length() - 1)).equals("ERR")) {
                                    NettyClient.this.sync_result.offer(Boolean.FALSE, 1L, TimeUnit.SECONDS);
                                } else if (data.equals("OK")) {
                                    NettyClient.this.sync_result.offer(Boolean.TRUE, 1L, TimeUnit.SECONDS);
                                } else {
                                    String[] params = data.split(",");
                                    NettyClient.this.ip = params[0];
                                    NettyClient.this.netmask = params[1];
                                    NettyClient.this.gateway = params[2];
                                    NettyClient.this.remember_last_state = params[4].equals("1");
                                    NettyClient.this.firmware_version = params[5];
                                    NettyClient.this.device_serial = params[6].substring(0, params[6].length() - 6);
                                    NettyClient.this.dns = params[7];
                                    NettyClient.this.cloud_url = params[8];
                                    NettyClient.this.cloud_enabled = params[9].equals("1");
                                    NettyClient.this.cloud_pass = params[6].substring(params[6].length() - 6, params[6].length());
                                    NettyClient.this.sync_result.offer("ready");
                                }
                            }
                            NettyClient.this.last_update2 = System.currentTimeMillis();
                        }
                    }
                });
            }
        });
        if (this.type == 1) {
            this.extra_t = new Thread(new Runnable(){

                @Override
                public void run() {
                    Random r = new Random();
                    do {
                        if (NettyClient.this.clientChannel != null && NettyClient.this.clientChannel.isActive()) {
                            if (NettyClient.this.type == 1) {
                                NettyClient.this.clientChannel.writeAndFlush(Unpooled.wrappedBuffer("00".getBytes()));
                            } else if (NettyClient.this.type == 2) {
                                // empty if block
                            }
                        }
                        try {
                            Thread.sleep(300L);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(NettyClient.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    } while (NettyClient.this.globalRetryCount >= 0);
                }
            });
            this.extra_t.setName("nettclient_polling_thread");
            this.extra_t.setDaemon(true);
            this.extra_t.start();
        }
        this.doConnect();
    }

    public void doConnect() {
        try {
            this.future = this.bootstrap.connect(this.serverHost, this.serverPort);
            this.future.addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        logger.info("netty client connect successfully." + NettyClient.this.serverHost + " " + NettyClient.this.serverPort);
                    } else {
                        logger.info("netty client connect failure. go to finally to retry." + NettyClient.this.serverHost + " " + NettyClient.this.serverPort);
                    }
                }
            });
            this.clientChannel = this.future.sync().channel();
            logger.info("clientChannel established.");
            this.clientChannel.closeFuture().sync();
        }
        catch (Exception e) {
            logger.info("NettyClient connect failed.  " + this.serverHost + " " + this.serverPort + " " + e.getMessage());
        }
        finally {
            if (this.globalRetryCount-- > 0) {
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {}
                logger.info("NettyClient connection lost. retry  " + (Integer.MAX_VALUE - this.globalRetryCount));
                this.doConnect();
            } else {
                this.workerGroup.shutdownGracefully();
                this.clientChannel = null;
                logger.info("Netty Client retry failure.");
            }
        }
    }

    public boolean isConnected() {
        if (this.clientChannel == null) {
            return false;
        }
        return this.clientChannel.isActive();
    }

    public void send(String text) {
        if (this.clientChannel != null && this.clientChannel.isActive()) {
            this.clientChannel.writeAndFlush(Unpooled.wrappedBuffer(text.getBytes(StandardCharsets.US_ASCII)));
        }
    }

    public Object sendSync(String text) {
        if (this.clientChannel != null && this.clientChannel.isActive()) {
            this.clientChannel.writeAndFlush(Unpooled.wrappedBuffer(text.getBytes(StandardCharsets.US_ASCII)));
        }
        try {
            return this.sync_result.poll(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(NettyClient.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NullPointerException ex) {
            Logger.getLogger(NettyClient.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    public void disconnect() {
        this.globalRetryCount = -1;
        if (this.clientChannel != null) {
            this.clientChannel.disconnect();
        }
    }

    public static class AsyncStartUpTask
    implements Runnable {
        private NettyClient nettyClient;

        public AsyncStartUpTask(NettyClient nettyClient) {
            this.nettyClient = nettyClient;
        }

        @Override
        public void run() {
            this.nettyClient.connect();
        }
    }
}

