/*
 * Decompiled with CFR 0.152.
 */
package io.hubbox.rc2desktopclient;

import io.hubbox.rc2desktopclient.NettyClient;
import java.util.HashMap;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public class Sr201Manager {
    static HashMap<String, NettyClient> tcp_clients = new HashMap();
    static Random r = new Random();

    public static HashMap<String, Object> readGates(String ip, int port) {
        if (!tcp_clients.containsKey(ip + ":" + port)) {
            NettyClient nettyClient = new NettyClient(ip, port, 1);
            Thread hhc_read_thread = new Thread(new NettyClient.AsyncStartUpTask(nettyClient));
            hhc_read_thread.setDaemon(true);
            hhc_read_thread.setName("sr201_read_thread");
            hhc_read_thread.start();
            tcp_clients.put(ip + ":" + port, nettyClient);
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(Sr201Manager.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        NettyClient nc = tcp_clients.get(ip + ":" + port);
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("ip", ip);
        hm.put("port", port);
        hm.put("connected", nc == null ? false : nc.isConnected());
        if (nc != null) {
            hm.put("date", nc.last_update1);
            hm.put("input1", nc.input);
            hm.put("output1", nc.output);
        }
        return hm;
    }

    public static HashMap<String, Object> readConf(String ip, int port) {
        NettyClient nc = new NettyClient(ip, port, 2);
        Thread hhc_read_thread = new Thread(new NettyClient.AsyncStartUpTask(nc));
        hhc_read_thread.setDaemon(true);
        hhc_read_thread.setName("sr201_readconf_thread");
        hhc_read_thread.start();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(Sr201Manager.class.getName()).log(Level.SEVERE, null, ex);
        }
        Object cevap = nc.sendSync("#1" + (r.nextInt(9000) + 1000) + ";");
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("ip", ip);
        hm.put("port", port);
        hm.put("connected", nc.isConnected());
        hm.put("date", nc.last_update2);
        hm.put("ip", nc.ip);
        hm.put("netmask", nc.netmask);
        hm.put("gateway", nc.gateway);
        hm.put("remember_last_state", nc.remember_last_state);
        hm.put("firmware_version", nc.firmware_version);
        hm.put("device_serial", nc.device_serial);
        hm.put("dns", nc.dns);
        hm.put("cloud_url", nc.cloud_url);
        hm.put("cloud_enabled", nc.cloud_enabled);
        hm.put("cloud_pass", nc.cloud_pass);
        return hm;
    }

    public static void setSingleOutput(String ip, int port, int relay, boolean state) {
        NettyClient nc = tcp_clients.get(ip + ":" + port);
        if (nc != null && nc.isConnected()) {
            nc.send((state ? "1" : "2") + relay);
        }
    }

    public static void setAllOutput(String ip, int port, boolean state) {
        NettyClient nc = tcp_clients.get(ip + ":" + port);
        if (nc != null && nc.isConnected()) {
            nc.send((state ? "1" : "2") + "X");
        }
    }

    public static Object setConf(String current_ip, int current_port, String new_ip, String netmask, String gateway, Boolean remember, String dns, String cloud_url, Boolean clound_enabled, String cloud_password) {
        NettyClient nc = new NettyClient(current_ip, current_port, 2);
        Thread hhc_read_thread = new Thread(new NettyClient.AsyncStartUpTask(nc));
        hhc_read_thread.setDaemon(true);
        hhc_read_thread.setName("sr201_readconf_thread");
        hhc_read_thread.start();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(Sr201Manager.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (nc.isConnected()) {
            Object cevap7;
            Object object;
            int random = Sr201Manager.getRandom();
            Object cevap1 = nc.sendSync("#1" + random + ";");
            Object cevap2 = nc.sendSync("#2" + random + "," + new_ip + ";");
            if (netmask != null) {
                object = nc.sendSync("#3" + random + "," + netmask + ";");
            }
            if (gateway != null) {
                object = nc.sendSync("#4" + random + "," + gateway + ";");
            }
            if (remember != null) {
                object = nc.sendSync("#6" + random + "," + (remember != false ? "1" : "0") + ";");
            }
            if (dns != null) {
                object = nc.sendSync("#8" + random + "," + dns + ";");
            }
            if (cloud_url != null) {
                object = nc.sendSync("#9" + random + "," + cloud_url + ";");
            }
            if (clound_enabled != null) {
                object = nc.sendSync("#A" + random + "," + (clound_enabled != false ? "1" : "0") + ";");
            }
            if (cloud_password != null) {
                object = nc.sendSync("#B" + random + "," + cloud_password + ";");
            }
            if ((cevap7 = nc.sendSync("#7" + random + ";")) instanceof Boolean) {
                return cevap7;
            }
        }
        return false;
    }

    private static int getRandom() {
        return r.nextInt(9000) + 1000;
    }

    public static void disconnectDevice(String ip, int port) {
        if (tcp_clients.containsKey(ip + ":" + port)) {
            NettyClient nc = tcp_clients.get(ip + ":" + port);
            nc.disconnect();
            tcp_clients.remove(ip + ":" + port);
        }
    }

    public static void closeAll() {
        for (NettyClient nc : tcp_clients.values()) {
            Sr201Manager.disconnectDevice(nc.getServerHost(), nc.getServerPort());
        }
    }

    public static void main(String[] args) {
        Sr201Manager.readGates("192.168.1.101", 6722);
        while (true) {
            JOptionPane.showConfirmDialog(null, "continue?");
            Sr201Manager.disconnectDevice("192.168.1.101", 6722);
        }
    }
}

