/*
 * Decompiled with CFR 0.152.
 */
package logtest;

import com.ghgande.j2mod.modbus.facade.ModbusTCPMaster;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configurator;

public class LogTest {
    static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static void main(String[] args) {
        System.setProperty("java.util.logging.manager", "org.apache.logging.log4j.jul.LogManager");
        Configurator.setRootLevel(Level.INFO);
        org.apache.logging.log4j.core.Logger log4j_logger = (org.apache.logging.log4j.core.Logger)LogManager.getRootLogger();
        Logger jul_logger = Logger.getLogger(LogTest.class.getName());
        for (Appender a : log4j_logger.getAppenders().values()) {
            log4j_logger.removeAppender(a);
        }
        class MockedAppender
        extends AbstractAppender {
            protected MockedAppender() {
                super("mock appender", null, null, true, null);
            }

            @Override
            public void append(LogEvent event) {
                StringBuilder sb = new StringBuilder();
                sb.append(sdf.format(new Date()) + " ");
                sb.append(event.getLevel() + " ");
                sb.append(event.getSource().getClassName() + " [");
                sb.append(event.getSource().getMethodName() + ":");
                sb.append(event.getSource().getLineNumber() + "] ");
                if (event.getThrown() != null) {
                    sb.append(event.getThrown().toString());
                }
                if (!event.getMessage().getFormattedMessage().equals("null")) {
                    sb.append(event.getMessage().getFormattedMessage() + " ");
                }
                System.out.println(sb.toString());
                if (event.getThrown() != null) {
                    event.getThrown().printStackTrace();
                }
            }
        }
        log4j_logger.addAppender(new MockedAppender());
        ModbusTCPMaster mm = new ModbusTCPMaster("192.168.1.2");
        try {
            mm.connect();
        }
        catch (Exception ex) {
            Logger.getLogger(LogTest.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        log4j_logger.info("test finished 1");
        jul_logger.info("test finished 2");
    }
}

